package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.constant.SentinelCommonConstants;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.consumer.SentinelNoticeConsumer;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.enums.SentinelConfigTypeEnum;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param.ClusterGroupParam;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param.ConfigTypeQueryParam;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.remoteservice.RemoteRuleConfigService;
import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Optional;

/**
 * @author huangguosheng@duiba.com.cn
 * @date 2022/2/25 2:03 下午
 **/
@Slf4j
@Configuration
@Import(value = {SentinelNoticeConsumer.class, OpenSentinelAutoConfiguration.class, DuibaClusterTokenClient.class})
@ConditionalOnProperty(prefix = "duiba.sentinel", name = "enable", havingValue = "true")
public class SentinelClientInit implements ApplicationRunner {
    @Value("${duiba.sentinel.namespace}")
    private String namespace;

    @Value("${duiba.sentinel.request.timeout}")
    private Integer requestTimeOut;

    @Autowired
    private RemoteRuleConfigService remoteRuleConfigService;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        //初始化客户端状态为client 或者 server
        initClusterState();

        //为每个client设置目标token server
        initClientServerAssignProperty();

        //初始化规则
        initClientRules();

        //初始化token client通用超时配置
        initClientConfigProperty();
    }


    /**
     * 初始化状态
     */
    private void initClusterState() {
        // 指定当前身份为 Token Client
        ClusterStateManager.applyState(ClusterStateManager.CLUSTER_CLIENT);
    }

    /**
     * 注册集群服务
     */
    private void initClientServerAssignProperty() {
//        ConfigTypeQueryParam param = ConfigTypeQueryParam.builder()
//                .configType(SentinelConfigTypeEnum.TOKEN_SERVER_INFO.getValue())
//                .key(SentinelCommonConstants.Config.TOKEN_SERVER_INFO).build();
//        String config = remoteRuleConfigService.getSentinelConfig(param);
//        if (StringUtils.isEmpty(config)) {
//            return;
//        }

        ReadableDataSource<String, ClusterClientAssignConfig> clientAssignDs = new DuibaSentinelDataSource<>("", source -> {
            List<ClusterGroupParam> groupList = JSON.parseObject(source, new TypeReference<List<ClusterGroupParam>>() {
            });
            return Optional.ofNullable(groupList)
                    .flatMap(this::extractClientAssignment)
                    .orElse(null);
        });
        ClusterClientConfigManager.registerServerAssignProperty(clientAssignDs.getProperty());
    }

    /**
     * 初始化客户端请求超时时间
     */
    private void initClientConfigProperty() {
        // 初始化一个配置ClusterClientConfig的 Nacos 数据源
        ReadableDataSource<String, ClusterClientConfig> ds = new DuibaSentinelDataSource<>(SentinelCommonConstants.Config.CLUSTER_CLIENT_CONFIG, source -> JSON.parseObject(source, new TypeReference<ClusterClientConfig>() {
        }));
        ClusterClientConfig config = new ClusterClientConfig();
        config.setRequestTimeout(requestTimeOut == null ? 100 : requestTimeOut);
        ds.getProperty().updateValue(config);
        ClusterClientConfigManager.registerClientConfigProperty(ds.getProperty());
    }

    /**
     * 初始化客户端规则
     *
     * @throws Exception
     */
    private void initClientRules() throws Exception {
        String key = SentinelCommonConstants.Config.APP_FLOW_RULES_SUFFIX.replace("{namespace}", namespace);
        ConfigTypeQueryParam param = ConfigTypeQueryParam.builder()
                .configType(SentinelConfigTypeEnum.FLOW_RULE.getValue())
                .key(key).build();
        String config = remoteRuleConfigService.getSentinelConfig(param);
        if (StringUtils.isEmpty(config)) {
            return;
        }

        ReadableDataSource<String, List<FlowRule>> ds = new DuibaSentinelDataSource<>(config,
                source -> JSON.parseObject(source, new TypeReference<List<FlowRule>>() {
                }));
        // 为集群客户端注册动态规则源
        FlowRuleManager.register2Property(ds.getProperty());
    }


    private Optional<ClusterClientAssignConfig> extractClientAssignment(List<ClusterGroupParam> groupList) {
        if (CollectionUtils.isEmpty(groupList)) {
            return Optional.empty();
        }
        ClusterGroupParam group = groupList.get(0);
        return Optional.of(new ClusterClientAssignConfig(group.getIp(), group.getPort()));
    }
}
