/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config.DuibaClusterTokenClient;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config.DuibaSentinelDataSource;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config.OpenSentinelAutoConfiguration;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.consumer.SentinelNoticeConsumer;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.enums.SentinelConfigTypeEnum;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param.ClusterGroupParam;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.param.ConfigTypeQueryParam;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.remoteservice.RemoteRuleConfigService;
import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={SentinelNoticeConsumer.class, OpenSentinelAutoConfiguration.class, DuibaClusterTokenClient.class})
@ConditionalOnProperty(prefix="duiba.sentinel", name={"enable"}, havingValue="true")
public class SentinelClientInit
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(SentinelClientInit.class);
    @Value(value="${duiba.sentinel.namespace}")
    private String namespace;
    @Value(value="${duiba.sentinel.request.timeout}")
    private Integer requestTimeOut;
    @Autowired
    private RemoteRuleConfigService remoteRuleConfigService;

    public void run(ApplicationArguments args) throws Exception {
        this.initClusterState();
        this.initClientServerAssignProperty();
        this.initClientRules();
        this.initClientConfigProperty();
    }

    private void initClusterState() {
        ClusterStateManager.applyState((Integer)0);
    }

    private void initClientServerAssignProperty() {
        ConfigTypeQueryParam param = ConfigTypeQueryParam.builder().configType(SentinelConfigTypeEnum.TOKEN_SERVER_INFO.getValue()).key("duiba-sentinel-server:token-server-info").build();
        String config = this.remoteRuleConfigService.getSentinelConfig(param);
        if (StringUtils.isEmpty((Object)config)) {
            return;
        }
        DuibaSentinelDataSource clientAssignDs = new DuibaSentinelDataSource("", source -> {
            List groupList = (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<ClusterGroupParam>>(){}, (Feature[])new Feature[0]);
            return Optional.ofNullable(groupList).flatMap(this::extractClientAssignment).orElse(null);
        });
        ClusterClientConfigManager.registerServerAssignProperty((SentinelProperty)clientAssignDs.getProperty());
    }

    private void initClientConfigProperty() {
        DuibaSentinelDataSource ds = new DuibaSentinelDataSource("duiba-sentinel-server:cluster-client-config", source -> (ClusterClientConfig)JSON.parseObject((String)source, (TypeReference)new TypeReference<ClusterClientConfig>(){}, (Feature[])new Feature[0]));
        ClusterClientConfig config = new ClusterClientConfig();
        config.setRequestTimeout(Integer.valueOf(this.requestTimeOut == null ? 100 : this.requestTimeOut));
        ds.getProperty().updateValue((Object)config);
        ClusterClientConfigManager.registerClientConfigProperty((SentinelProperty)ds.getProperty());
    }

    private void initClientRules() throws Exception {
        String key = "duiba-sentinel-server:{namespace}-flow-rules".replace("{namespace}", this.namespace);
        ConfigTypeQueryParam param = ConfigTypeQueryParam.builder().configType(SentinelConfigTypeEnum.FLOW_RULE.getValue()).key(key).build();
        String config = this.remoteRuleConfigService.getSentinelConfig(param);
        if (StringUtils.isEmpty((Object)config)) {
            return;
        }
        DuibaSentinelDataSource ds = new DuibaSentinelDataSource(config, source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]));
        FlowRuleManager.register2Property((SentinelProperty)ds.getProperty());
    }

    private Optional<ClusterClientAssignConfig> extractClientAssignment(List<ClusterGroupParam> groupList) {
        if (CollectionUtils.isEmpty(groupList)) {
            return Optional.empty();
        }
        ClusterGroupParam group = groupList.get(0);
        return Optional.of(new ClusterClientAssignConfig(group.getIp(), group.getPort()));
    }
}

