/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config;

import cn.hutool.core.util.HashUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerManage {
    private static final Logger log = LoggerFactory.getLogger(ServerManage.class);
    private static SortedMap<Integer, String> sortedMap = new TreeMap<Integer, String>();
    private static String localhost = "127.0.0.1";

    public static void initServer(List<String> servers) {
        sortedMap.clear();
        servers.forEach(server -> {
            int hash = HashUtil.fnvHash((String)server);
            sortedMap.put(hash, (String)server);
            log.info("[{}]\u52a0\u5165\u96c6\u5408\u4e2d, \u5176Hash\u503c\u4e3a\uff1a{}", server, (Object)hash);
        });
    }

    public static void addServer(String host) {
        int hash = HashUtil.fnvHash((String)host);
        sortedMap.put(hash, host);
        log.info("[{}]\u52a0\u5165\u96c6\u5408\u4e2d, \u5176Hash\u503c\u4e3a\uff1a{}", (Object)host, (Object)hash);
    }

    public static String getServer(String host) {
        int hash = HashUtil.fnvHash((String)host);
        return (String)sortedMap.get(hash);
    }

    public static void removeServer(String host) {
        int hash = HashUtil.fnvHash((String)host);
        sortedMap.remove(hash);
    }

    public static void removeServer(List<String> servers) {
        servers.forEach(server -> {
            int hash = HashUtil.fnvHash((String)server);
            sortedMap.remove(hash);
        });
    }

    public static List<String> getServers() {
        return new ArrayList<String>(sortedMap.values());
    }

    public static String getRouterServer(String host) {
        if (sortedMap.size() == 0) {
            return localhost;
        }
        int hash = HashUtil.fnvHash((String)host);
        SortedMap<Integer, String> subMap = sortedMap.tailMap(hash);
        if (subMap.isEmpty()) {
            Integer i = sortedMap.firstKey();
            return (String)sortedMap.get(i);
        }
        Integer i = subMap.firstKey();
        return (String)subMap.get(i);
    }

    public static void main(String[] args) {
        int i;
        List<String> servers = Arrays.asList("128.0.0.1", "128.0.0.2");
        ServerManage.initServer(servers);
        String[] keys = new String[]{"\u592a\u9633", "\u6708\u4eae", "\u661f\u661f"};
        for (i = 0; i < keys.length; ++i) {
            System.out.println("[" + keys[i] + "]\u7684hash\u503c\u4e3a" + HashUtil.fnvHash((String)keys[i]) + ", \u88ab\u8def\u7531\u5230\u7ed3\u70b9[" + ServerManage.getRouterServer(keys[i]) + "]");
        }
        ServerManage.addServer("128.0.0.3");
        for (i = 0; i < keys.length; ++i) {
            System.out.println("[" + keys[i] + "]\u7684hash\u503c\u4e3a" + HashUtil.fnvHash((String)keys[i]) + ", \u88ab\u8def\u7531\u5230\u7ed3\u70b9[" + ServerManage.getRouterServer(keys[i]) + "]");
        }
        ServerManage.removeServer("128.0.0.2");
        ServerManage.removeServer("128.0.0.1");
        ServerManage.removeServer("128.0.0.3");
        ServerManage.addServer("128.0.0.8");
        for (i = 0; i < keys.length; ++i) {
            System.out.println("[" + keys[i] + "]\u7684hash\u503c\u4e3a" + HashUtil.fnvHash((String)keys[i]) + ", \u88ab\u8def\u7531\u5230\u7ed3\u70b9[" + ServerManage.getRouterServer(keys[i]) + "]");
        }
    }
}

