package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.enums;

import lombok.Getter;

/**
 * 限流规则类型
 *
 * @author huangguosheng@duiba.com.cn
 * @date 2021/12/27 10:12 上午
 **/
@Getter
public enum SentinelRuleTypeEnum {

    /**
     * 规则类型
     */
    FLOW_RULE(1, "限流规则"),
    DEGRADE_RULE(2, "熔断规则"),
    PARAM_FLOW_RULE(3, "热点限流规则"),
    SYSTEM_RULE(4, "系统规则"),
    ;


    private Integer value;

    private String desc;

    SentinelRuleTypeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static String getDesc(int value) {
        for (SentinelRuleTypeEnum item : SentinelRuleTypeEnum.values()) {
            if (item.value == value) {
                return item.desc;
            }
        }
        return "";
    }

    public static SentinelRuleTypeEnum valueOf(Integer value) {
        for (SentinelRuleTypeEnum param : values()) {
            if (param.getValue().equals(value)) {
                return param;
            }
        }
        return null;
    }

    public byte getByteValue() {
        return value.byteValue();
    }
}
