/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config;

import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.config.ServerManage;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.dto.TokenServiceConfigDTO;
import cn.com.duiba.cloud.duiba.sentinel.service.api.remoteservice.remoteservice.RemoteRuleConfigService;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.csp.sentinel.cluster.ClusterTransportClient;
import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.TokenServerDescriptor;
import com.alibaba.csp.sentinel.cluster.client.ClusterTokenClient;
import com.alibaba.csp.sentinel.cluster.client.NettyTransportClient;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.cluster.client.config.ServerChangeObserver;
import com.alibaba.csp.sentinel.cluster.log.ClusterClientStatLogUtil;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.request.data.FlowRequestData;
import com.alibaba.csp.sentinel.cluster.request.data.ParamFlowRequestData;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.cluster.response.data.FlowTokenResponseData;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuibaClusterTokenClient
implements ClusterTokenClient {
    private static final Logger log = LoggerFactory.getLogger(DuibaClusterTokenClient.class);
    private static HashMap<String, ClusterTransportClient> transportClientMap = new HashMap();
    private static HashMap<String, TokenServerDescriptor> serverDescriptorMap = new HashMap();
    private final AtomicBoolean shouldStart = new AtomicBoolean(false);

    public DuibaClusterTokenClient() {
        ClusterClientConfigManager.addServerChangeObserver((ServerChangeObserver)new ServerChangeObserver(){

            public void onRemoteServerChange(ClusterClientAssignConfig assignConfig) {
                DuibaClusterTokenClient.this.changeServer(assignConfig);
            }
        });
    }

    private boolean serverEqual(TokenServerDescriptor descriptor, ClusterClientAssignConfig config) {
        if (descriptor == null || config == null) {
            return false;
        }
        return descriptor.getHost().equals(config.getServerHost()) && descriptor.getPort() == config.getServerPort().intValue();
    }

    private void initNewConnection() {
        RemoteRuleConfigService configService = (RemoteRuleConfigService)SpringUtil.getBean(RemoteRuleConfigService.class);
        if (configService == null) {
            return;
        }
        List<TokenServiceConfigDTO> tokenServices = configService.getTokenServices();
        for (TokenServiceConfigDTO item : tokenServices) {
            String server;
            if (StringUtil.isBlank((String)item.getHost()) || item.getPort() <= 0) continue;
            try {
                if (transportClientMap.get(item.getHost()) == null) {
                    NettyTransportClient transportClient = new NettyTransportClient(item.getHost(), item.getPort().intValue());
                    transportClientMap.put(item.getHost(), (ClusterTransportClient)transportClient);
                    TokenServerDescriptor serverDescriptor = new TokenServerDescriptor(item.getHost(), item.getPort().intValue());
                    serverDescriptorMap.put(item.getHost(), serverDescriptor);
                    log.info("[DuibaClusterTokenClient] New client created: " + serverDescriptor);
                    this.startClient((ClusterTransportClient)transportClient);
                }
            }
            catch (Exception ex) {
                log.warn("[DuibaClusterTokenClient] Failed to initialize new token client", (Throwable)ex);
            }
            if (!StringUtil.isBlank((String)(server = ServerManage.getServer(item.getHost())))) continue;
            ServerManage.addServer(item.getHost());
        }
        log.info("[DuibaClusterTokenClient]  client created done:{}", serverDescriptorMap);
    }

    private void changeServer(ClusterClientAssignConfig assignConfig) {
        ClusterTransportClient transportClient = transportClientMap.get(assignConfig.getServerHost());
        if (transportClient != null) {
            try {
                transportClient.stop();
                log.info("[DuibaClusterTokenClient] \u505c\u6b62 ip:{} token-server\u8fde\u63a5", (Object)assignConfig.getServerHost());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            transportClientMap.remove(assignConfig.getServerHost());
            serverDescriptorMap.remove(assignConfig.getServerHost());
        }
        this.initNewConnection();
    }

    private void startClientIfScheduled() throws Exception {
        if (this.shouldStart.get()) {
            for (Map.Entry<String, ClusterTransportClient> entry : transportClientMap.entrySet()) {
                if (entry.getValue() != null) {
                    this.startClient(entry.getValue());
                    continue;
                }
                log.warn("[DuibaClusterTokenClient] Cannot start transport client: client not created");
            }
        }
    }

    private void startClient(ClusterTransportClient client) throws Exception {
        client.start();
    }

    private void stopClientIfStarted() throws Exception {
        if (this.shouldStart.compareAndSet(true, false)) {
            for (Map.Entry<String, ClusterTransportClient> entry : transportClientMap.entrySet()) {
                if (entry.getValue() != null) {
                    entry.getValue().stop();
                    continue;
                }
                log.warn("[DuibaClusterTokenClient] Cannot stop transport client: client not created");
            }
        }
    }

    public void start() throws Exception {
        if (this.shouldStart.compareAndSet(false, true)) {
            this.startClientIfScheduled();
        }
    }

    public void stop() throws Exception {
        this.stopClientIfStarted();
    }

    public int getState() {
        boolean isOk = true;
        for (Map.Entry<String, ClusterTransportClient> entry : transportClientMap.entrySet()) {
            if (entry.getValue() == null) {
                isOk = false;
            }
            if (entry.getValue().isReady()) continue;
            isOk = false;
        }
        return isOk ? 2 : 0;
    }

    public TokenServerDescriptor currentServer() {
        return null;
    }

    public TokenResult requestToken(Long flowId, int acquireCount, boolean prioritized) {
        if (this.notValidRequest(flowId, acquireCount)) {
            return this.badRequest();
        }
        FlowRequestData data = new FlowRequestData().setCount(acquireCount).setFlowId(flowId.longValue()).setPriority(prioritized);
        ClusterRequest request = new ClusterRequest(1, (Object)data);
        try {
            TokenResult result = this.sendTokenRequest(request, flowId);
            this.logForResult(result);
            return result;
        }
        catch (Exception ex) {
            ClusterClientStatLogUtil.log((String)ex.getMessage());
            return new TokenResult(Integer.valueOf(-1));
        }
    }

    public TokenResult requestParamToken(Long flowId, int acquireCount, Collection<Object> params) {
        if (this.notValidRequest(flowId, acquireCount) || params == null || params.isEmpty()) {
            return this.badRequest();
        }
        ParamFlowRequestData data = new ParamFlowRequestData().setCount(acquireCount).setFlowId(flowId.longValue()).setParams(params);
        ClusterRequest request = new ClusterRequest(2, (Object)data);
        try {
            TokenResult result = this.sendTokenRequest(request, flowId);
            this.logForResult(result);
            return result;
        }
        catch (Exception ex) {
            ClusterClientStatLogUtil.log((String)ex.getMessage());
            return new TokenResult(Integer.valueOf(-1));
        }
    }

    private void logForResult(TokenResult result) {
        switch (result.getStatus()) {
            case 3: {
                ClusterClientStatLogUtil.log((String)"no rules in token server");
                break;
            }
            case -2: {
                ClusterClientStatLogUtil.log((String)"too many requests (client side)");
                break;
            }
        }
    }

    private TokenResult sendTokenRequest(ClusterRequest request, Long flowId) throws Exception {
        String server = ServerManage.getRouterServer("" + flowId);
        ClusterTransportClient transportClient = transportClientMap.get(server);
        if (transportClient == null) {
            log.warn("[DuibaClusterTokenClient] Client not created, please check your config for cluster client");
            return this.clientFail();
        }
        ClusterResponse response = transportClient.sendRequest(request);
        TokenResult result = new TokenResult(Integer.valueOf(response.getStatus()));
        if (response.getData() != null) {
            FlowTokenResponseData responseData = (FlowTokenResponseData)response.getData();
            result.setRemaining(responseData.getRemainingCount()).setWaitInMs(responseData.getWaitInMs());
        }
        return result;
    }

    private boolean notValidRequest(Long id, int count) {
        return id == null || id <= 0L || count <= 0;
    }

    private TokenResult badRequest() {
        return new TokenResult(Integer.valueOf(-4));
    }

    private TokenResult clientFail() {
        return new TokenResult(Integer.valueOf(-1));
    }
}

