package cn.com.duiba.cloud.manage.service.api.model.param.app;

import cn.com.duiba.cloud.manage.service.api.model.param.BaseParam;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 租户应用更新
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/3/30
 */
@Getter
@Setter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RemoteTenantAppUpdateParam extends BaseParam {

    private static final long serialVersionUID = -3822836889199661782L;

    /**
     * 租户应用名称
     */
    private String tenantAppName;

    /**
     * 应用标签
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.TenantAppTagEnum
     */
    private Long tenantAppTag;

    /**
     * 业务主体
     * @see cn.com.duiba.cloud.manage.service.api.model.enums.BusinessEntityEnum
     */
    private Long businessEntityId;

}
