package cn.com.duiba.cloud.manage.service.autologin.sdk.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 请求工具类
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/24
 */
public class OpenApiRequestTool {

    private static final ThreadLocal<OpenApiRequestTool> LOCAL = new ThreadLocal<>();
    private HttpServletRequest request;
    private HttpServletResponse response;
    private JSONObject adminInfo;

    /**
     * 获取请求工具
     * @return
     */
    private static OpenApiRequestTool get() {
        if (LOCAL.get() == null) {
            throw new RuntimeException("未设置本地变量");
        }
        return LOCAL.get();
    }

    /**
     * 设置请求到本地变量中
     * @param request
     * @param response
     */
    public static void setRequestInThreadLocal(HttpServletRequest request, HttpServletResponse response) {
        if (request == null) {
            throw new IllegalArgumentException("RequestTool注入request为空");
        }
        if (response == null) {
            throw new IllegalArgumentException("RequestTool注入response为空");
        }
        OpenApiRequestTool tool = new OpenApiRequestTool();
        tool.request = request;
        tool.response = response;
        tool.adminInfo = new JSONObject();
        LOCAL.set(tool);
    }

    /**
     * 删除本地变量
     */
    public static void removeRequestInThreadLocal(){
        LOCAL.remove();
    }

    /**
     * 是否是异步或者json格式的请求
     * @return
     */
    public static Boolean isAsynchronousRequests() {
        HttpServletRequest request = getRequest();
        String re = request.getHeader("x-requested-with");
        String accept = request.getHeader("Accept");
        return (StringUtils.isNotBlank(re) && StringUtils.equals("XMLHttpRequest", re)) || (
                StringUtils.isNotBlank(accept) && accept.contains("json"));
    }

    public static HttpServletResponse getResponse() {
        return get().response;
    }

    public static HttpServletRequest getRequest() {
        return get().request;
    }

    public static JSONObject getAdminInfo() {
        return get().adminInfo;
    }

}
