package cn.com.duiba.cloud.manage.service.autologin.sdk.utils;

import cn.com.duiba.cloud.manage.service.api.model.dto.autologin.ConsumerCookieDTO;

/**
 * 登录工具
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/24
 */
public class LoginUtils {

    public static final String CONSUMER_INFO_KEY = "consumerInfo";

    public static void setConsumerInfo(ConsumerCookieDTO consumerInfo) {
        OpenApiRequestTool.getAdminInfo().put(CONSUMER_INFO_KEY, consumerInfo);
    }

    public static ConsumerCookieDTO getConsumerInfo() {
        if (!OpenApiRequestTool.getAdminInfo().containsKey(CONSUMER_INFO_KEY)) {
            throw new IllegalArgumentException("未设置客户信息，请在调用此方法前确保调用LoginUtils.setConsumerInfo进行设置");
        }
        return (ConsumerCookieDTO) OpenApiRequestTool.getAdminInfo().get(CONSUMER_INFO_KEY);
    }

    public static Long getCid() {
        return getConsumerInfo().getCid();
    }

    public static Long getAppId() {
        return getConsumerInfo().getAppId();
    }

    public static String getPartnerUserId() {
        return getConsumerInfo().getPartnerUserId();
    }

    public static Long getLoginTime() {
        return getConsumerInfo().getLoginTime();
    }

}
