package cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.dto.autologin.ConsumerCookieDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import cn.com.duiba.cloud.manage.service.api.utils.AutoLoginUtil;
import cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.annotation.TenantAppTradeLimitAnnotation;
import cn.com.duiba.cloud.manage.service.autologin.sdk.utils.AutoLoginRequestTool;
import cn.com.duiba.cloud.manage.service.autologin.sdk.verification.CommonVerification;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

import javax.annotation.Resource;
import java.util.Objects;

/**
 *
 * 校验交易限制开关是否打开
 *
 * @program: duiba-manage-service
 * @description:
 * @author: 郭云龙
 * @create: 2022-05-30 15:09
 **/
@Slf4j
public class TenantAppTradeLimitHandler implements AutoLoginInterceptorHandler {

    @Resource
    private CommonVerification commonVerification;

    @Override
    public Boolean accept(Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod) handler;

            TenantAppTradeLimitAnnotation tenantAppTradeLimitAnnotation = AnnotationUtils.getAnnotation(method.getMethod(), TenantAppTradeLimitAnnotation.class);

            //如果注解不存在，直接返回
            if(Objects.isNull(tenantAppTradeLimitAnnotation)){
                return Boolean.TRUE;
            }

            //获取参数的需继续联调，防止取不到信息
            String tenantAppId = AutoLoginRequestTool.getRequest().getParameter(tenantAppTradeLimitAnnotation.fieldVerity());
            //如果取不到值，通过cookie获取
            if(StringUtils.isBlank(tenantAppId)){
                ConsumerCookieDTO consumerCookieDTO = AutoLoginUtil.getConsumerInfo();
                AssertUtil.isNotNull(consumerCookieDTO,ErrorCode.TENANT_APP_ID_NOT_NULL);
                tenantAppId = String.valueOf(consumerCookieDTO.getAppId());
            }
            AssertUtil.isNotNull(tenantAppId,ErrorCode.TENANT_APP_ID_NOT_NULL);

            Boolean verifyTenantAppTradeLimit = commonVerification.verifyTenantAppTradeLimit(Long.parseLong(tenantAppId));
            if ( verifyTenantAppTradeLimit ) {
                return Boolean.TRUE;
            } else {
                log.error("tenantApp:{} tradeLimitSwitch:{} ",tenantAppId,verifyTenantAppTradeLimit);
                throw new BizException(ErrorCode.TENANT_APP_TRADE_LIMIT_OPEN.getMsg()).withCode(ErrorCode.TENANT_APP_TRADE_LIMIT_OPEN.getCode());
            }

        }

        return Boolean.TRUE;
    }

    @Override
    public int getOrder() {
        return 11;
    }
}
