package cn.com.duiba.cloud.manage.service.autologin.sdk.interceptor.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 交易限制开关注解
 *
 * @author gyl
 * @version 1.0
 * @date 2022/5/30
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
@Documented
public @interface TenantAppTradeLimitAnnotation {

    /**
     * 指定验证字段,必须指定
     */
    String fieldVerity();

    /**
     * 无权限的提示信息
     * @return
     */
    String message() default "您访问页面正在升级，如有疑问请联系客服";
}
