package cn.com.duiba.cloud.manage.service.autologin.sdk.verification.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.TenantAppDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.TradeLimitSwitchEnum;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.remoteservice.app.RemoteTenantAppService;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import cn.com.duiba.cloud.manage.service.autologin.sdk.verification.CommonVerification;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

/**
 * @program: duiba-manage-service
 * @description: 通用校验
 * @author: 郭云龙
 * @create: 2022-05-30 15:56
 **/
@Service
public class CommonVerificationImpl implements CommonVerification {

    @Resource
    RemoteTenantAppService remoteTenantAppService;

    @Override
    //todo 缓存 缓存更新是一个问题 1分钟或者两分钟应该可以
    public TenantAppDTO detail(Long id) throws BizException {
        return remoteTenantAppService.detail(id);
    }

    @Override
    public Boolean verifyTenantAppOverdue(Long id) throws BizException {
        AssertUtil.isNotNull(id, ErrorCode.TENANT_APP_ID_NOT_NULL);
        TenantAppDTO tenantAppDTO = this.detail(id);
        AssertUtil.isNotNull(tenantAppDTO, ErrorCode.TENANT_NOT_SUBSCRIBE_APP);
        AssertUtil.isNotNull(tenantAppDTO.getValidPeriod(), ErrorCode.DATA_ERROR);

        Date now = new Date(System.currentTimeMillis());

        //应用过期，直接返回
        if(tenantAppDTO.getValidPeriod().before(now)){
            return Boolean.FALSE;
        }

        return Boolean.TRUE;
    }

    @Override
    public Boolean verifyTenantAppTradeLimit(Long id) throws BizException {
        AssertUtil.isNotNull(id, ErrorCode.TENANT_APP_ID_NOT_NULL);
        TenantAppDTO tenantAppDTO = this.detail(id);
        AssertUtil.isNotNull(tenantAppDTO, ErrorCode.TENANT_NOT_SUBSCRIBE_APP);
        AssertUtil.isNotNull(tenantAppDTO.getTradeLimitSwitch(), ErrorCode.DATA_ERROR);
        //交易限制打开,直接返回
        if(TradeLimitSwitchEnum.OPEN.getCode().equals(tenantAppDTO.getTradeLimitSwitch())){
            return Boolean.FALSE;
        }

        return Boolean.TRUE;
    }
}
