/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.sdk.handler;

import cn.com.duiba.cloud.manage.sdk.annotation.TenantAppTradeLimitAnnotation;
import cn.com.duiba.cloud.manage.sdk.handler.ToCManageServiceHandler;
import cn.com.duiba.cloud.manage.sdk.utils.ToCManageServiceRequestTool;
import cn.com.duiba.cloud.manage.sdk.verification.CommonVerification;
import cn.com.duiba.cloud.manage.service.api.model.dto.autologin.ConsumerCookieDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import cn.com.duiba.cloud.manage.service.api.utils.AutoLoginUtil;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public class TenantAppTradeLimitHandler
implements ToCManageServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantAppTradeLimitHandler.class);
    @Resource
    private CommonVerification commonVerification;

    @Override
    public Boolean accept(Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            TenantAppTradeLimitAnnotation tenantAppTradeLimitAnnotation = (TenantAppTradeLimitAnnotation)AnnotationUtils.getAnnotation((Method)method.getMethod(), TenantAppTradeLimitAnnotation.class);
            if (Objects.isNull(tenantAppTradeLimitAnnotation)) {
                return Boolean.TRUE;
            }
            String tenantAppId = ToCManageServiceRequestTool.getRequest().getParameter(tenantAppTradeLimitAnnotation.fieldVerity());
            if (StringUtils.isBlank((String)tenantAppId)) {
                ConsumerCookieDTO consumerCookieDTO = AutoLoginUtil.getConsumerInfo();
                AssertUtil.isNotNull((Object)consumerCookieDTO, (ErrorCode)ErrorCode.TENANT_APP_ID_NOT_NULL, (Object[])new Object[0]);
                tenantAppId = String.valueOf(consumerCookieDTO.getAppId());
            }
            AssertUtil.isNotNull((Object)tenantAppId, (ErrorCode)ErrorCode.TENANT_APP_ID_NOT_NULL, (Object[])new Object[0]);
            Boolean verifyTenantAppTradeLimit = this.commonVerification.verifyTenantAppTradeLimit(Long.parseLong(tenantAppId));
            if (verifyTenantAppTradeLimit.booleanValue()) {
                return Boolean.TRUE;
            }
            log.error("tenantApp:{} tradeLimitSwitch:{} ", (Object)tenantAppId, (Object)verifyTenantAppTradeLimit);
            ToCManageServiceRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
            JsonResult result = JsonResult.fail((String)ErrorCode.TENANT_APP_TRADE_LIMIT_OPEN.getCode(), (String)ErrorCode.TENANT_APP_TRADE_LIMIT_OPEN.getMsg());
            ToCManageServiceRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 11;
    }
}

