package cn.com.duiba.cloud.manage.sdk.interceptor;

import cn.com.duiba.cloud.manage.sdk.handler.ToCManageServiceHandler;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 应用管理拦截管理器
 *
 * @author gyl
 * @version 1.0
 * @date 2022/5/24
 */
public class ToCManageServiceHandlerManager {

    @Autowired(required = false)
    List<ToCManageServiceHandler> interceptorHandlerList;

    public Boolean doHandler(Object handler) throws Exception {
        if (interceptorHandlerList == null || interceptorHandlerList.isEmpty()) {
            return true;
        }
        for (ToCManageServiceHandler interceptorHandler : interceptorHandlerList) {
            if (!interceptorHandler.accept(handler)) {
                return false;
            }
        }
        return true;
    }

}
