package cn.com.duiba.cloud.manage.service.api.service.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.model.dto.app.AppDetailDTO;
import cn.com.duiba.cloud.manage.service.api.model.enums.exception.ErrorCode;
import cn.com.duiba.cloud.manage.service.api.model.param.app.RemoteAppSecretQueryParam;
import cn.com.duiba.cloud.manage.service.api.remoteservice.app.RemoteAppService;
import cn.com.duiba.cloud.manage.service.api.service.SignService;
import cn.com.duiba.cloud.manage.service.api.utils.AssertUtil;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @program: duiba-manage-service
 * @description: 订阅应用接口实现类
 * @author: 郭云龙
 * @create: 2022-03-03 13:41
 **/
@Service
public class SignServiceImpl implements SignService {
    @Resource
    private RemoteAppService remoteAppService;
    /**
     * 获得appSecret
     *
     * @param appKey
     * @return
     */
    @Override
    @Cacheable(value = "appSecret")
    public String getAppSecret(String appKey) throws BizException {
        System.out.println("我必须执行的------------------");
        AppDetailDTO appDetailDTO = this.getAppDetail(appKey);
        AssertUtil.isNotNull(appDetailDTO, ErrorCode.APP_NOT_EXISTS);
        AssertUtil.isNotBlank(appDetailDTO.getAppSecret(), ErrorCode.APP_NOT_EXISTS);
        return appDetailDTO.getAppSecret();
    }

    /**
     * 通过appKey获取订阅app详情
     *
     * @param appKey
     * @return
     */
    private AppDetailDTO getAppDetail(String appKey) throws BizException {
        System.out.println("假如我执行，就是缓存没生效------------------");
        RemoteAppSecretQueryParam param = new RemoteAppSecretQueryParam();
        param.setAppKey(appKey);
        AppDetailDTO appDTO = remoteAppService.getAppSecret(param);
        return appDTO;
    }

}
