package cn.com.duiba.cloud.manage.service.api.util;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.api.service.SignService;
import cn.com.duiba.wolf.utils.SecurityUtils;
import cn.hutool.crypto.digest.DigestUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.nio.charset.StandardCharsets;
import java.util.Map;

/**
 * @program: duiba-manage-service
 * @description: 签名工作类
 * @author: 郭云龙
 * @create: 2022-03-03 17:45
 **/
@Component
public class SignUtil implements ApplicationContextAware {

    private static SignService signService;

    public static String sign(Map<String, Object> map, String appKey) throws BizException {
        String appSecret = signService.getAppSecret(appKey);
        return signWithAppSecret(map, appSecret);
    }

    public static boolean signCheck(Map<String, Object> map, String appKey, String sign) throws BizException {
        return sign.equals(sign(map, appKey));
    }

    /**
     * 带入AppSecret签名
     *
     * @param map
     * @param appSecret
     * @return
     * @throws BizException
     */
    public static String signWithAppSecret(Map<String, Object> map, String appSecret) throws BizException {
        String data = JSON.toJSONString(map, SerializerFeature.MapSortField);
        data += appSecret;
        return DigestUtil.md5Hex(data).toUpperCase();
    }

    /**
     * 带入签名key
     *
     * @param map
     * @param appSecret
     * @param sign
     * @return
     * @throws BizException
     */
    public static boolean signWithAppSecretCheck(Map<String, Object> map, String appSecret, String sign) throws BizException {
        return sign.equals(signWithAppSecret(map, appSecret));
    }

    /**
     * Aes加密+Base64
     *
     * @param data
     * @param appKey
     * @return
     */
    public static String encrypt(String data, String appKey) throws BizException {
        if (StringUtils.isBlank(appKey)) {
            throw new NullPointerException("appKey不能为空");
        }
        String appSecret = signService.getAppSecret(appKey);
        return encryptWithAppSecret(data, appSecret);
    }

    public static String encryptWithAppSecret(String data, String appSecret) {
        return SecurityUtils.encode2StringByBase64(SecurityUtils.encodeByAes(data, appSecret));
    }

    /**
     * Aes解密+Base64解密
     *
     * @param data
     * @param appKey
     * @return
     */
    public static String decrypt(String data, String appKey) throws BizException {
        if (StringUtils.isBlank(appKey)) {
            throw new NullPointerException("appKey不能为空");
        }
        String appSecret = signService.getAppSecret(appKey);
        return decryptWithAppSecret(data, appSecret);
    }

    public static String decryptWithAppSecret(String data, String appSecret) {
        return new String(SecurityUtils.decodeByAes(SecurityUtils.decodeBase64(data), appSecret), StandardCharsets.UTF_8);
    }


    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SignUtil.signService = applicationContext.getBean(SignService.class);
    }
}
