package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.consumer.center.api.dto.AppSignConfigDto;
import cn.com.duiba.consumer.center.api.dto.ConsumerSignInfoDto;
import cn.com.duiba.consumer.center.api.dto.SignResultDto;
import cn.com.duiba.consumer.center.api.params.AppSignConfigParams;
import cn.com.duiba.consumer.center.api.params.SignLogParams;
import cn.com.duiba.consumer.center.api.params.SignParams;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by liuyao on 2016/12/12.
 */
public interface RemoteSignSystemService {

    /**
     * 用户获取签到数据
     * @param consumerId
     * @return
     */
    DubboResult<ConsumerSignInfoDto> getConsumerSignInfoDto(Long consumerId);
    /**
     * 用户签到
     * @param params
     * @return
     */
     DubboResult<SignResultDto> doSignIn(SignParams params);

    /**
     * 获取签到配置信息
     * @param appId
     * @return
     */
     DubboResult<AppSignConfigDto> getSignInConfigInfo(Long appId);

    /**
     * 提交签到配置信息
     * @param params
     * @return
     */
     DubboResult<Boolean> updateSignInConfig(AppSignConfigParams params);

    /**
     * 创建并获取签到流水Id号
     * @param params
     * @return
     */
     DubboResult<Long> createSignLog(SignLogParams params);

    /**
     * 将流水号变为失败
     * @param logId
     * @return
     */
     DubboResult<Boolean> setSignLogStatue(Long logId,Integer logStatue);
}
