package cn.com.duiba.consumer.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.ConsumerCreditsLogDto;
import cn.com.duiba.consumer.center.api.dto.ConsumerCreditsLogParamDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.api.bo.page.PageQuery;
import cn.com.duiba.consumer.center.api.dto.ConsumerCreditsLogSaveDto;

import java.util.List;
import java.util.Map;

/**
 * Created by fangdong on 2018/09/30
 */
@AdvancedFeignClient
public interface RemoteConsumerCreditLogService {

    /**
     * 分页查询用户积分记录
     * @param param 查询参数
     * @param query 分页参数
     * @return 用户积分记录分页结果
     * @throws BizException 业务异常
     */
    Page<ConsumerCreditsLogDto> pageApi(ConsumerCreditsLogParamDto param, PageQuery query) throws BizException;

    /**
     * 查询多个用户积分记录
     * @param param
     * @return
     * @throws BizException
     */
    Map<Long, List<ConsumerCreditsLogDto>> queryListForConsumerListApi(ConsumerCreditsLogParamDto param) throws BizException;

    /**
     * 条件查询积分
     * @param param 参数
     * @return 积分
     */
    Long getCredits(ConsumerCreditsLogParamDto param) throws BizException;

    /**
     * 保存用户积分流水记录
     * @param consumerCreditsLogSaveDto
     * @return
     * @throws BizException
     */
    Long saveCreditsLog(ConsumerCreditsLogSaveDto consumerCreditsLogSaveDto) throws BizException;
}
