package cn.com.duiba.consumer.center.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.consumer.center.api.dto.ReceiveAddressDto;
import cn.com.duiba.consumer.center.api.dto.address.AreaCode;
import cn.com.duiba.consumer.center.api.dto.address.CustomAddress;

import java.util.List;
import java.util.Map;


/**
 * 定制用户地址服务
 *
 * @author lyj
 */
@AdvancedFeignClient
public interface RemoteCustomAddressService {

    /**
     * 是否是定制用户地址应用
     *
     * @param appId 应用ID
     * @return true - 改应用有定制地址ID
     * @throws Exception 异常
     */
    boolean isCustomAddressAppId(Long appId);

    /**
     * 通过父层级获取子层级列表
     *
     * @param appId      应用ID
     * @param parentCode 父层级code
     * @return 子层级列表
     * @throws Exception 异常
     */
    List<AreaCode> getSubAreaCode(Long appId, String parentCode) throws Exception;

    /**
     * 构建用户兑吧地址返回结构
     *
     * @param appId         应用ID
     * @param partnerUserId 用户ID
     * @param addressId     地址ID
     * @return 用户兑吧地址返回数据
     * @throws Exception 异常
     */
    ReceiveAddressDto buildDuibaReceiveAddressDto(Long appId, String partnerUserId, String addressId) throws Exception;

    /**
     * 获取用户地址列表
     *
     * @param appId         应用ID
     * @param partnerUserId 用户ID
     * @return 用户地址列表
     * @throws Exception 异常
     */
    List<CustomAddress> getUserAllAddress(Long appId, String partnerUserId) throws Exception;

    /**
     * 获取用户默认地址
     *
     * @param appId         应用ID
     * @param partnerUserId 用户ID
     * @return 用户默认地址
     * @throws Exception 异常
     */
    CustomAddress getUserDefaultAddress(Long appId, String partnerUserId) throws Exception;

    /**
     * 获取用户指定地址
     *
     * @param appId         应用ID
     * @param partnerUserId 用户ID
     * @param addressId     地址ID
     * @return 用户默认地址
     * @throws Exception 异常
     */
    CustomAddress getUserOrderAddress(Long appId, String partnerUserId, String addressId) throws Exception;


    /**
     * 构建更新地址请求dto
     * @param appId 应用ID
     * @param paramMap 请求参数
     * @return 返回对象
     * @throws Exception 异常
     */
     CustomAddress buildUpdateUserAddressDto(Long appId, Map<String, String[]> paramMap) throws Exception;

    /**
     * 修改用户地址
     *
     * @param appId         应用ID
     * @param partnerUserId 用户ID
     * @param address       用户地址
     * @throws Exception 异常
     */
    void updateUserAddress(Long appId, String partnerUserId, CustomAddress address) throws Exception;

    /**
     * 删除用户地址
     *
     * @param appId         应用ID
     * @param partnerUserId 用户ID
     * @param addressId     地址ID
     * @throws Exception 异常
     */
    void deleteUserAddress(Long appId, String partnerUserId, String addressId) throws Exception;


}
