package cn.com.duiba.credits.credits.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.credits.credits.center.api.dto.AddCreditsDto;
import cn.com.duiba.credits.credits.center.api.dto.DeductCreditsDto;

/**
 * 兑吧拖管中心积分服务
 *
 */
@AdvancedFeignClient
public interface RemoteCreditsTrustService {

	/**
	 * 针对兑吧拖管积分，减积分
	 * @param request
	 * @return
	 */
	Boolean submitSubCredits(DeductCreditsDto request);

	/**
	 * 针对兑吧拖管积分，查积分
	 * @param consumerId
	 * @return
	 */
	Long queryCreditsByConsumerId(Long consumerId);

	/**
	 * 针对兑吧拖管积分，加积分
	 * @param addCreditsDto
	 * @return
	 */
	Boolean submitAddCredits(AddCreditsDto addCreditsDto);
}
