package cn.com.duiba.customer.link.project.api.remoteservice.app98160.param;

import javax.validation.constraints.NotBlank;

/**
 * @Author huliangsheng
 * @Date 2025/9/15 10:56
 */
public class ActivityJoinParam {

    /**
     * 统计日期,格式:yyyy-MM-dd
     */
    @NotBlank(message = "统计日期不能为空")
    private String statisticalDate;

    /**
     * 用户id
     */
    @NotBlank(message = "用户id不能为空")
    private String openId;

    /**
     * 用户手机号
     */
    @NotBlank(message = "用户手机号不能为空")
    private String mobile;

    /**
     * 用户省份
     */
    @NotBlank(message = "用户省份不能为空")
    private String province;

    /**
     * 用户城市
     */
    @NotBlank(message = "用户城市不能为空")
    private String area;

    /**
     * 当日完成活动次数
     */
    @NotBlank(message = "当日完成活动次数不能为空")
    private Integer completeCount;

    /**
     * 当日首次参与活动时间.格式yyyy-MM-dd HH:mm:ss
     */
    @NotBlank(message = "当日首次参与活动时间不能为空")
    private String firstTime;

    /**
     * 是否参与抽奖 Y:是 N:否
     */
    @NotBlank(message = "抽奖状态不能为空")
    private String isDraw;

    /**
     * 中奖奖品名称
     */
    private String prizeName;

    /**
     * 完成任务	Y:是 N:否
     */
    private String finishTask;

    /**
     * 分享次数
     */
    private Integer shareCount;

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public Integer getCompleteCount() {
        return completeCount;
    }

    public void setCompleteCount(Integer completeCount) {
        this.completeCount = completeCount;
    }

    public String getFinishTask() {
        return finishTask;
    }

    public void setFinishTask(String finishTask) {
        this.finishTask = finishTask;
    }

    public String getFirstTime() {
        return firstTime;
    }

    public void setFirstTime(String firstTime) {
        this.firstTime = firstTime;
    }

    public String getIsDraw() {
        return isDraw;
    }

    public void setIsDraw(String isDraw) {
        this.isDraw = isDraw;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getPrizeName() {
        return prizeName;
    }

    public void setPrizeName(String prizeName) {
        this.prizeName = prizeName;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public Integer getShareCount() {
        return shareCount;
    }

    public void setShareCount(Integer shareCount) {
        this.shareCount = shareCount;
    }

    public String getStatisticalDate() {
        return statisticalDate;
    }

    public void setStatisticalDate(String statisticalDate) {
        this.statisticalDate = statisticalDate;
    }
}
