package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * QQ小程序大单购、积分扫码数据响应
 * 
 * @author zhangdaqing
 * @date 2025/9/20 18:00
 */
public class QQBuyInfoResponse {
    
    private final int Return;
    private final String Result;
    
    /**
     * 构造函数
     */
    public QQBuyInfoResponse(int Return, String Result) {
        this.Return = Return;
        this.Result = Result;
    }
    
    // Getter方法
    public int getReturn() { return Return; }
    public String getResult() { return Result; }
    
    /**
     * 判断是否成功
     */
    public boolean isSuccess() {
        return Return >= 0;
    }
    
    /**
     * 判断是否参与大单购
     * Return=0: 参加大单购; Return=1: 未参加大单购; Return<0: 失败
     */
    public boolean isParticipatedInBulkPurchase() {
        return Return == 0;
    }
    
    /**
     * 判断是否未参与大单购
     */
    public boolean isNotParticipatedInBulkPurchase() {
        return Return == 1;
    }
    
    /**
     * 获取积分扫码数据列表
     */
    public List<QQBuyInfoItem> getBuyInfoList() {
        if (!isSuccess() || Result == null || Result.trim().isEmpty()) {
            return new ArrayList<>();
        }
        
        try {
            JSONArray jsonArray = JSONArray.parseArray(Result);
            List<QQBuyInfoItem> itemList = new ArrayList<>();
            
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject itemJson = jsonArray.getJSONObject(i);
                QQBuyInfoItem item = new QQBuyInfoItem(
                    itemJson.getString("PNTID"),
                    itemJson.getString("ProductCode"),
                    itemJson.getString("PNTTime")
                );
                itemList.add(item);
            }
            
            return itemList;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }
    
    /**
     * 从JSON字符串创建响应对象
     */
    public static QQBuyInfoResponse fromJsonString(String jsonString) {
        try {
            JSONObject json = JSONObject.parseObject(jsonString);
            int returnCode = json.getIntValue("Return");
            String result = json.getString("Result");
            return new QQBuyInfoResponse(returnCode, result);
        } catch (Exception e) {
            throw new IllegalArgumentException("无效的响应JSON格式: " + jsonString, e);
        }
    }
    
    /**
     * 积分扫码数据项
     */
    public static class QQBuyInfoItem {
        private final String pntId;        // 积分ID
        private final String productCode;  // 积分产品编码
        private final String pntTime;      // 积分时间
        
        public QQBuyInfoItem(String pntId, String productCode, String pntTime) {
            this.pntId = pntId;
            this.productCode = productCode;
            this.pntTime = pntTime;
        }
        
        // Getter方法
        public String getPntId() { return pntId; }
        public String getProductCode() { return productCode; }
        public String getPntTime() { return pntTime; }
        
        @Override
        public String toString() {
            return "QQBuyInfoItem{" +
                    "pntId='" + pntId + '\'' +
                    ", productCode='" + productCode + '\'' +
                    ", pntTime='" + pntTime + '\'' +
                    '}';
        }
    }
}

