/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto.QQBuyInfoItem;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class QQBuyInfoResponse {
    private final int Return;
    private final String Result;

    public QQBuyInfoResponse(int Return, String Result2) {
        this.Return = Return;
        this.Result = Result2;
    }

    public int getReturn() {
        return this.Return;
    }

    public String getResult() {
        return this.Result;
    }

    public boolean isSuccess() {
        return this.Return >= 0;
    }

    public boolean isParticipatedInBulkPurchase() {
        return this.Return == 1;
    }

    public boolean isNotParticipatedInBulkPurchase() {
        return this.Return == 0;
    }

    public List<QQBuyInfoItem> getBuyInfoList() {
        if (!this.isSuccess() || this.Result == null || this.Result.trim().isEmpty()) {
            return new ArrayList<QQBuyInfoItem>();
        }
        try {
            JSONArray jsonArray = JSONArray.parseArray((String)this.Result);
            ArrayList<QQBuyInfoItem> itemList = new ArrayList<QQBuyInfoItem>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject itemJson = jsonArray.getJSONObject(i);
                QQBuyInfoItem item = new QQBuyInfoItem(itemJson.getString("PNTID"), itemJson.getString("ProductCode"), itemJson.getString("PNTTime"));
                itemList.add(item);
            }
            return itemList;
        }
        catch (Exception e) {
            return new ArrayList<QQBuyInfoItem>();
        }
    }

    public static QQBuyInfoResponse fromJsonString(String jsonString) {
        try {
            JSONObject json = JSONObject.parseObject((String)jsonString);
            int returnCode = json.getIntValue("Return");
            String result = json.getString("Result");
            return new QQBuyInfoResponse(returnCode, result);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u54cd\u5e94JSON\u683c\u5f0f: " + jsonString, e);
        }
    }
}

