package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import org.apache.commons.lang3.StringUtils;

/**
 * QQ小程序中奖订单新增请求参数
 * 
 * @author zhangdaqing
 * @date 2025/9/20 18:30
 */
public class QQAwardOrderAddRequest {
    
    private final String openID;        // 粉丝ID
    private final String sheetCode;     // 订单编码
    private final String consignee;     // 收件人姓名
    private final String mobile;        // 电话
    private final String officialCity;  // 收货城市
    private final String address;       // 详细地址
    private final String giftCode;      // 礼品编码
    private final String getQuantity;   // 礼品数量
    private final String authKey;       // 授权码
    
    /**
     * 构造函数，验证输入参数
     */
    public QQAwardOrderAddRequest(String openID, String sheetCode, String consignee, 
                                 String mobile, String officialCity, String address, 
                                 String giftCode, String getQuantity, String authKey) {
        if (StringUtils.isBlank(openID)) {
            throw new IllegalArgumentException("OpenID不能为空");
        }
        if (StringUtils.isBlank(sheetCode)) {
            throw new IllegalArgumentException("订单编码不能为空");
        }
        if (StringUtils.isBlank(consignee)) {
            throw new IllegalArgumentException("收件人姓名不能为空");
        }
        if (StringUtils.isBlank(mobile)) {
            throw new IllegalArgumentException("电话不能为空");
        }
        if (StringUtils.isBlank(officialCity)) {
            throw new IllegalArgumentException("收货城市不能为空");
        }
        if (StringUtils.isBlank(address)) {
            throw new IllegalArgumentException("详细地址不能为空");
        }
        if (StringUtils.isBlank(giftCode)) {
            throw new IllegalArgumentException("礼品编码不能为空");
        }
        if (StringUtils.isBlank(getQuantity)) {
            throw new IllegalArgumentException("礼品数量不能为空");
        }
        if (StringUtils.isBlank(authKey)) {
            throw new IllegalArgumentException("授权码不能为空");
        }
        
        this.openID = openID;
        this.sheetCode = sheetCode;
        this.consignee = consignee;
        this.mobile = mobile;
        this.officialCity = officialCity;
        this.address = address;
        this.giftCode = giftCode;
        this.getQuantity = getQuantity;
        this.authKey = authKey;
    }
    
    // Getter方法
    public String getOpenID() { return openID; }
    public String getSheetCode() { return sheetCode; }
    public String getConsignee() { return consignee; }
    public String getMobile() { return mobile; }
    public String getOfficialCity() { return officialCity; }
    public String getAddress() { return address; }
    public String getGiftCode() { return giftCode; }
    public String getGetQuantity() { return getQuantity; }
    public String getAuthKey() { return authKey; }
    
    @Override
    public String toString() {
        return "QQAwardOrderAddRequest{" +
                "openID='" + openID + '\'' +
                ", sheetCode='" + sheetCode + '\'' +
                ", consignee='" + consignee + '\'' +
                ", mobile='" + mobile + '\'' +
                ", officialCity='" + officialCity + '\'' +
                ", address='" + address + '\'' +
                ", giftCode='" + giftCode + '\'' +
                ", getQuantity='" + getQuantity + '\'' +
                ", authKey='" + authKey + '\'' +
                '}';
    }
}
