package cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto.req;


import java.util.List;

/**
 * ConfirmTransferRequest
 */
public class ConfirmTransferRequest {
    /**
     * 必填
     * 商户appid 说明：申请商户号的appid或商户号绑定的appid（企业号corpid即为此appid）
     */
    private String appid;

    /**
     * 必填
     * 【商户单号】 商户系统内部的商家单号，要求此参数只能由数字、大小写字母组成，在商户系统内部唯一
     */
    private String out_bill_no;

    /**
     * 必填
     * 【转账场景ID】 该笔转账使用的转账场景，可前往“商户平台-产品中心-商家转账”中申请。如：1001-现金营销
     */
    private String transfer_scene_id;

    /**
     * 必填
     * 【收款用户OpenID】 用户在商户appid下的唯一标识。发起转账前需获取到用户的OpenID
     */
    private String openid;

    /**
     * 【收款用户姓名】 收款方真实姓名。需要加密传入，支持标准RSA算法和国密算法，公钥由微信侧提供。
     * 转账金额 >= 2,000元时，该笔明细必须填写
     * 若商户传入收款用户姓名，微信支付会校验收款用户与输入姓名是否一致，并提供电子回单
     */
    private String user_name;
    /**
     * 必填
     * 【转账金额】 转账金额单位为“分”。
     */
    private Integer transfer_amount;
    /**
     * 必填
     * 【转账备注】 转账备注，用户收款时可见该备注信息，UTF8编码，最多允许32个字符
     */
    private String transfer_remark;
    /**
     * 【通知地址】 异步接收微信支付结果通知的回调地址，通知url必须为公网可访问的URL，必须为HTTPS，不能携带参数。
     */
    private String notify_url;
    /**
     * 【用户收款感知】 用户收款时感知到的收款原因将根据转账场景自动展示默认内容。如有其他展示需求，可在本字段传入。各场景展示的默认内容和支持传入的内容，可查看产品文档了解。
     */
    private String user_recv_perception;
    /**
     * 必填
     * 【转账场景报备信息】 各转账场景下需报备的内容，商户需要按照所属转账场景规则传参，详见转账场景报备信息字段说明。
     */
    private List<TransferSceneReportInfos> transfer_scene_report_infos;

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getOut_bill_no() {
        return out_bill_no;
    }

    public void setOut_bill_no(String out_bill_no) {
        this.out_bill_no = out_bill_no;
    }

    public String getTransfer_scene_id() {
        return transfer_scene_id;
    }

    public void setTransfer_scene_id(String transfer_scene_id) {
        this.transfer_scene_id = transfer_scene_id;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getUser_name() {
        return user_name;
    }

    public void setUser_name(String user_name) {
        this.user_name = user_name;
    }


    public String getTransfer_remark() {
        return transfer_remark;
    }

    public void setTransfer_remark(String transfer_remark) {
        this.transfer_remark = transfer_remark;
    }

    public String getNotify_url() {
        return notify_url;
    }

    public void setNotify_url(String notify_url) {
        this.notify_url = notify_url;
    }

    public String getUser_recv_perception() {
        return user_recv_perception;
    }

    public void setUser_recv_perception(String user_recv_perception) {
        this.user_recv_perception = user_recv_perception;
    }

    public List<TransferSceneReportInfos> getTransfer_scene_report_infos() {
        return transfer_scene_report_infos;
    }

    public void setTransfer_scene_report_infos(List<TransferSceneReportInfos> transfer_scene_report_infos) {
        this.transfer_scene_report_infos = transfer_scene_report_infos;
    }

    public Integer getTransfer_amount() {
        return transfer_amount;
    }

    public void setTransfer_amount(Integer transfer_amount) {
        this.transfer_amount = transfer_amount;
    }

    public static class TransferSceneReportInfos {
        /**
         * 【信息类型】
         * 不能超过15个字符，商户所属转账场景下的信息类型，此字段内容为固定值，需严格按照转账场景报备信息字段说明传参。
         */
        private String info_type;
        /**
         * 【信息内容】
         * 不能超过32个字符，商户所属转账场景下的信息内容，商户可按实际业务场景自定义传参，需严格按照转账场景报备信息字段说明传参。
         */
        private String info_content;

        public String getInfo_type() {
            return info_type;
        }

        public void setInfo_type(String info_type) {
            this.info_type = info_type;
        }

        public String getInfo_content() {
            return info_content;
        }

        public void setInfo_content(String info_content) {
            this.info_content = info_content;
        }
    }
}
