package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * 图像识别请求DTO
 * 
 * @author Generated
 * @since 2024
 */
public class ImageRecognitionRequestDto {
    
    /**
     * 模型名称
     */
    @JsonProperty("model")
    @NotBlank(message = "模型名称不能为空")
    private String model = "qwen-vl-max";
    
    /**
     * 消息列表
     */
    @JsonProperty("messages")
    @NotEmpty(message = "消息列表不能为空")
    private List<MessageDto> messages;

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public List<MessageDto> getMessages() {
        return messages;
    }

    public void setMessages(List<MessageDto> messages) {
        this.messages = messages;
    }

    /**
     * 消息DTO
     */
    public static class MessageDto {
        
        /**
         * 角色
         */
        @JsonProperty("role")
        @NotBlank(message = "角色不能为空")
        private String role;
        
        /**
         * 内容列表
         */
        @JsonProperty("content")
        @NotEmpty(message = "内容不能为空")
        private List<ContentDto> content;

        public String getRole() {
            return role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public List<ContentDto> getContent() {
            return content;
        }

        public void setContent(List<ContentDto> content) {
            this.content = content;
        }
    }
    
    /**
     * 内容DTO
     */
    public static class ContentDto {
        
        /**
         * 类型
         */
        @JsonProperty("type")
        @NotBlank(message = "内容类型不能为空")
        private String type;
        
        /**
         * 文本内容
         */
        @JsonProperty("text")
        private String text;
        
        /**
         * 图像URL
         */
        @JsonProperty("image_url")
        private ImageUrlDto imageUrl;

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public ImageUrlDto getImageUrl() {
            return imageUrl;
        }

        public void setImageUrl(ImageUrlDto imageUrl) {
            this.imageUrl = imageUrl;
        }
    }
    
    /**
     * 图像URL DTO
     */
    public static class ImageUrlDto {
        
        /**
         * 图像URL
         */
        @JsonProperty("url")
        @NotBlank(message = "图像URL不能为空")
        private String url;

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}
