package cn.com.duiba.customer.link.project.api.remoteservice.app89420;

import cn.com.duiba.customer.link.project.api.remoteservice.app89420.dto.LastScanDrawReq;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.dto.LastScanDrawRes;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.dto.MemberSeasonReq;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.dto.MemberSeasonRes;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.dto.NewSpecialRedReq;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.dto.NewSpecialRedRes;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.dto.RiskResultReq;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.dto.ScanDrawStatisticsReq;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.dto.ScanDrawStatisticsResp;
import cn.com.duiba.customer.link.project.api.remoteservice.app89420.vo.*;

/**
 * @Author WeiChaoChao
 * @Description 口味王接口
 * @Date 2023/1/6
 **/
public interface RemoteKwwService {
    /**
     * 2.3.18
     * 查询是否完善用户信息
     *
     * @param userId 用户Id
     * @return
     */
    HasPerfectUserInfoRes hasPerfectUserInfo(String userId);

    /**
     * 2.3.19
     * 查询用户消费记录
     *
     * @param req
     * @return
     */
    ConsumeRecordRes queryConsumeRecord(ConsumeRecordReq req);

    /**
     * 2.3.21
     * 查询用户消费记录
     *
     * @param req
     * @return
     */
    NewConsumeRecordRes queryNewConsumeRecord(ConsumeRecordReq req);

    /**
     * 查询用户扫码消费记录
     * @param req req
     * @return
     */
    NewConsumeRecordsRes queryNewConsumeRecords(NewConsumeRecordReq req);

    /**
     * 2.3.20
     * 查询用户新年订阅消息记录
     *
     * @param userId
     * @param activityNo 不传时返回两个活动的订阅状态
     * @return
     */
    SubscribeNewYearMsgRecordRes querySubscribeMsgRecord(String userId, String activityNo);

    /**
     * 查询小程序订阅状态
     * @param userId 用户ID
     * @param openId dcustomMap中取到到"openid"
     * @param id 订阅ID
     * @return 订阅结果
     */
    ChannelSubscribeRes queryChannelSubscribeRes(String userId, String openId, String id);


    /**
     * 用户手动补发接口
     *
     * @param req
     */
    SelfPushResultRes selfPush(SelfPushReq req);


    /**
     * 批量推送发钱接口
     * 具体怎么推送，一次推多少条和技术支持确认
     *
     * @param req
     */
    SendMoneyRes sendMoney(SendMoneyReq req);

    /**
     * 查询发钱订单状态接口
     * @return
     */
    QueryMoneyOrderStatusRes queryMoneyOrderStatus(QueryMoneyOrderStatusReq req);

    /**
     * 活动信息同步
     * @param req
     * @return boolean
     */
    boolean activityInfoSynchronization(ActivityInfoSynchronizationReq req);

    /**
     * 查询活动信息
     * @param req
     * @return QueryActivityInfoRes
     */
    QueryActivityInfoRes queryActivityInfo(QueryActivityInfoReq req);


    /**
     * 2.3.30
     * 年度账单
     * @param userId
     * @return {@link Bill2023Resp}
     */
    Bill2023Resp get2023BillInfo(String userId);

    /**
     * 发放红包
     * @param req
     * @return boolean
     */
    boolean sendSpecialRed(SpecialRedReq req);


    /**
     * 发放优惠券
     * @param req
     * @return boolean
     */
    boolean sendSpecialCoupon(SpecialCouponReq req);

    /**
     * 查询风控结果
     *
     * @param req 请求入参
     * @return 风控结果
     */
    RiskResultRes queryRiskResultRes(RiskResultReq req);

    /**
     * 查询2024年度账单
     *
     * @param req 请求入参
     * @return 结果
     */
    Year2024BillRes get2024BillInfo(Year2024BillReq req);


    /**
     * 专享红包发放(走商家自冲)
     *
     * @param req req
     * @return 发放结果
     */
    NewSpecialRedRes sendNewSpecialRed(NewSpecialRedReq req);

    /**
     * 查询最近一次扫码抽奖时间
     *
     * @param req
     * @return
     */
    LastScanDrawRes queryLastScanDraw(LastScanDrawReq req);


    /**
     * 获取会员赛季详情
     */
    MemberSeasonRes getMemberSeasonInfo(MemberSeasonReq req);


    /**
     * 获取周期内累积扫码金额
     */
    ScanDrawStatisticsResp queryScanTotalAmount(ScanDrawStatisticsReq req);

    /**
     * 查询口味王2025年度账单
     *
     * @param req 请求入参
     * @return 结果
     */
    Year2025BillRes getKww2025BillInfo(Year2025BillReq req);

}
