package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * QQ宝宝信息保存请求DTO
 *
 * @author zhangdaqing
 * @date 2025/1/27
 */
public class QQBabyInfoRequest {



    /**
     * 宝宝ID，新增时为空
     */
    @JsonProperty("babyId")
    private String babyId;

    /**
     * 宝宝名称
     */
    @JsonProperty("babyName")
    @NotNull(message = "宝宝名称不能为空")
    private String babyName;

    /**
     * 性别，0男1女
     */
    @JsonProperty("gender")
    @NotNull(message = "性别不能为空")
    private Integer gender;

    /**
     * 生日时间戳13位
     */
    @JsonProperty("birthday")
    @NotNull(message = "生日不能为空")
    private Long birthday;

    /**
     * 宝宝身高cm
     */
    @JsonProperty("babyHeight")
    @NotNull(message = "宝宝身高不能为空")
    private BigDecimal babyHeight;

    /**
     * 宝宝体重kg
     */
    @JsonProperty("babyWeight")
    @NotNull(message = "宝宝体重不能为空")
    private BigDecimal babyWeight;

    /**
     * 妈妈身高cm
     */
    @JsonProperty("momsHeight")
    @NotNull(message = "妈妈身高不能为空")
    private BigDecimal momsHeight;

    /**
     * 爸爸身高cm
     */
    @JsonProperty("dadsHeight")
    @NotNull(message = "爸爸身高不能为空")
    private BigDecimal dadsHeight;

    /**
     * 成年后期望身高cm
     */
    @JsonProperty("expectedHeight")
    @NotNull(message = "期望身高不能为空")
    private BigDecimal expectedHeight;

    /**
     * 用户unionId
     */
    @JsonProperty("unionId")
    @NotNull(message = "unionId不能为空")
    private String unionId;

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getBabyId() {
        return babyId;
    }

    public void setBabyId(String babyId) {
        this.babyId = babyId;
    }

    public String getBabyName() {
        return babyName;
    }

    public void setBabyName(String babyName) {
        this.babyName = babyName;
    }

    public Integer getGender() {
        return gender;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public Long getBirthday() {
        return birthday;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }

    public BigDecimal getBabyHeight() {
        return babyHeight;
    }

    public void setBabyHeight(BigDecimal babyHeight) {
        this.babyHeight = babyHeight;
    }

    public BigDecimal getBabyWeight() {
        return babyWeight;
    }

    public void setBabyWeight(BigDecimal babyWeight) {
        this.babyWeight = babyWeight;
    }

    public BigDecimal getMomsHeight() {
        return momsHeight;
    }

    public void setMomsHeight(BigDecimal momsHeight) {
        this.momsHeight = momsHeight;
    }

    public BigDecimal getDadsHeight() {
        return dadsHeight;
    }

    public void setDadsHeight(BigDecimal dadsHeight) {
        this.dadsHeight = dadsHeight;
    }

    public BigDecimal getExpectedHeight() {
        return expectedHeight;
    }

    public void setExpectedHeight(BigDecimal expectedHeight) {
        this.expectedHeight = expectedHeight;
    }
}
