package cn.com.duiba.api;

import com.alibaba.fastjson.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by houwen on 2017/6/7.
 */
public class MongodbDts {

    private String host = "http://localhost:9666";

    private String apiGruop = "/api/mongodb/";

    public MongodbDts(String host) {
        this.host = host;
    }

    public void save(String id, String value) {
        String api = host + apiGruop + "save";
        Map<String, String> params = new HashMap<>();
        params.put("id", id);
        params.put("value", value);
        HttpClient.execute(api, params);
    }

    public void remove(String id) {
        String api = host + apiGruop + "remove";
        Map<String, String> params = new HashMap<>();
        params.put("id", id);
        HttpClient.execute(api, params);
    }

    public String findById(String id) {
        String api = host + apiGruop + "findById";
        Map<String, String> params = new HashMap<>();
        params.put("id", id);
        String body = HttpClient.execute(api, params);
        JSONObject json = JSONObject.parseObject(body);
        return json.getString("data");
    }

    public void insert(String id, String value) {
        String api = host + apiGruop + "insert";
        Map<String, String> params = new HashMap<>();
        params.put("id", id);
        params.put("value", value);
        HttpClient.execute(api, params);
    }

    public void insetAll(Map<String, String> data) {
        String api = host + apiGruop + "insertAll";
        Map<String, String> params = new HashMap<>();
        params.put("docs", JSONObject.toJSONString(data));
        HttpClient.execute(api, params);
    }
}
