/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClient {
    private static long keepaliveTimeout = 60000L;
    private static int connectTimeout = 20000;
    private static int socketTimtout = 60000;
    private static int maxConnTotal = 500;
    private static CloseableHttpClient httpClient = HttpClient.createClient();

    public static CloseableHttpClient createClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimtout).setConnectionRequestTimeout(connectTimeout).build();
        return HttpClients.custom().setDefaultRequestConfig(config).setKeepAliveStrategy((ConnectionKeepAliveStrategy)HttpClient.getKeepAliveStrategy()).build();
    }

    private static DefaultConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1L) {
                    return keepaliveTimeout;
                }
                return duration;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execute(String url, Map<String, String> params) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> args = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                args.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(args));
            response = httpClient.execute((HttpUriRequest)httpPost);
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

