package cn.com.duiba.api;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * HttpClient
 */
public class HttpClient {

    private static long keepaliveTimeout = 60 * 1000;

    private static int connectTimeout = 30 * 1000;

    private static int socketTimtout = 30 * 1000;

    private static int maxConnTotal = 500;


    private static CloseableHttpClient httpClient = createClient();

    /**
     * 获取HttpClient
     *
     * @return
     */
    public static CloseableHttpClient createClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimtout).setConnectionRequestTimeout(connectTimeout).build();
        return HttpClients.custom().setDefaultRequestConfig(config).setKeepAliveStrategy(getKeepAliveStrategy()).build();
    }

    /**
     * 长连接
     *
     * @return
     */
    private static DefaultConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy() {
            @Override
            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long duration = super.getKeepAliveDuration(response, context);
                if (duration == -1) {
                    return keepaliveTimeout;
                }
                return duration;
            }
        };
    }


    /**
     * 执行http请求
     *
     * @param url
     * @param params
     * @return
     */
    public static String execute(String url, Map<String, String> params) {
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            List<NameValuePair> args = new ArrayList<>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                args.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity(new UrlEncodedFormEntity(args));
            response = httpClient.execute(httpPost);
            return EntityUtils.toString(response.getEntity());
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                response.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }


}
