package cn.com.duiba.api;


import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * HttpClient
 */
public class HttpClient {

    private static DefaultHttpClient httpClient = new DefaultHttpClient();

    /**
     * 执行http请求
     *
     * @param url
     * @param params
     * @return
     */
    public static String execute(String url, Map<String, String> params) {
        HttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            List<NameValuePair> args = new ArrayList<>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                args.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity(new UrlEncodedFormEntity(args));
            response = httpClient.execute(httpPost);
            return EntityUtils.toString(response.getEntity());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


}
