package cn.com.duiba.api;

/**
 * ErrorCode
 */
public enum ErrorCode {

    DTS_0101001("DTS_0000001", "参数为空"),

    DTS_0101002("DTS_0000002", "参数错误"),

    DTS_0101003("DTS_0000003", "超出限制"),

    DTS_0101004("DTS_0000004", "无权访问"),

    DTS_0101999("DTS_0009999", "系统异常"),

    ;

    private String code;

    private String desc;

    ErrorCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
    
	public String getJson() {
		return "{\"" + code + "\":\"" + desc + "\"}";
	}
	
}
