package cn.com.duiba.api;


import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.util.EntityUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * HttpClient
 */
public class HttpClient {

    private static final int timeout = 5000;

    /**
     * 执行http请求
     *
     * @param url
     * @param params
     * @return
     */
    public static String execute(String url, Map<String, String> params) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpConnectionParams.setConnectionTimeout(httpClient.getParams(), timeout);
            HttpConnectionParams.setSoTimeout(httpClient.getParams(), timeout);
            HttpPost httpPost = new HttpPost(url);
            List<NameValuePair> args = new ArrayList<>();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                args.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            httpPost.setEntity(new UrlEncodedFormEntity(args));
            HttpResponse response = httpClient.execute(httpPost);
            HttpEntity entity = response.getEntity();
            return EntityUtils.toString(entity);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
