package cn.com.duiba.developer.center.api.domain.dto.visualeditor;

import java.io.Serializable;

/**
 * HBase数据迁移结果DTO
 * 
 * @author system
 * @date 2025/01/XX
 */
public class HbaseMigrationResultDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 总记录数
     */
    private int totalCount;

    /**
     * 成功迁移数
     */
    private int successCount;

    /**
     * 失败数
     */
    private int failCount;

    /**
     * HBase中未找到数据数（包括空数据）
     */
    private int notFoundCount;

    /**
     * 结果消息
     */
    private String message;

    public HbaseMigrationResultDto() {
    }

    public HbaseMigrationResultDto(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public int getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getSuccessCount() {
        return successCount;
    }

    public void setSuccessCount(int successCount) {
        this.successCount = successCount;
    }

    public int getFailCount() {
        return failCount;
    }

    public void setFailCount(int failCount) {
        this.failCount = failCount;
    }

    public int getNotFoundCount() {
        return notFoundCount;
    }

    public void setNotFoundCount(int notFoundCount) {
        this.notFoundCount = notFoundCount;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return "HbaseMigrationResultDto{" +
                "appId=" + appId +
                ", totalCount=" + totalCount +
                ", successCount=" + successCount +
                ", failCount=" + failCount +
                ", notFoundCount=" + notFoundCount +
                ", message='" + message + '\'' +
                '}';
    }
}
