package cn.com.duiba.developer.center.api.domain.enums;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * app收银台支付渠道类型
 * Created by sunyan on 2019/6/25.
 */
public enum AppPaychannelEnum {
    ALIPAY(0,"alipay","支付宝支付"),
    WXPAY(1, "wxpay","微信支付"),
    LITEPAY(2,"litepay", "小程序支付");

    private Integer code;
    private String type;
    private String desc;

    private static Map<String, AppPaychannelEnum> typeMap = new HashMap<>();

    static {
        for (AppPaychannelEnum typeEnum : values()) {
            typeMap.put(typeEnum.getType(), typeEnum);
        }
    }

    public static AppPaychannelEnum getAppPaychannelByType(String type) {
        if (type == null || !typeMap.containsKey(type)) {
            return null;
        }
        return typeMap.get(type);
    }

    /**
     * 获得开启的支付渠道
     * @param appPayChannelSwitch
     * @return
     */
    public static List<AppPaychannelEnum> getOpenChannelListBySwitch(Long appPayChannelSwitch){
        List<AppPaychannelEnum> list = new ArrayList<>();
        for (AppPaychannelEnum typeEnum : values()) {
            if(isSwitch(typeEnum.getCode(),appPayChannelSwitch)){
                list.add(typeEnum);
            }
        }
        return list;
    }

    /**
     * 用来判断开关位的状态
     * @param boundType 开关位
     * @return 是否开启
     */
    public static boolean isSwitch(int boundType,Long appPayChannelSwitch) {
        long v = 1 << boundType;
        long ret = appPayChannelSwitch & v;
        return ret != 0;
    }


    AppPaychannelEnum(Integer code, String type ,String desc) {
        this.code = code;
        this.type = type;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getType() {
        return type;
    }
}
