package cn.com.duiba.developer.center.api.domain.param;

import java.io.Serializable;
import java.util.List;

/**
 * 查询开发者 组件化皮肤列表的参数
 */
public class VisualEditorAppSkinQueryIndexParam implements Serializable {


    private static final long serialVersionUID = 5267689148082496137L;
    /**
     * 应用id
     * notNull
     */
    private Long appId;

    /**
     * 标识位(参考statusSwitch)
     * isNullAble:0,defaultVal:0
     */
    private Integer openStatus;

    /**
     * 皮肤名称（模糊查询）
     */
    private String skinName;
    /**
     * 是否包含首页
     */
    private Boolean includeIndex = true;

    /**
     * SkinModeEnum
     * 皮肤类型，是否悠闲查询备份数据
     * 如果优先查询,先查询备份，如果备份没有，返回源数据
     *
     */
    private Integer skinMode;

    /**
     * 删除标志位(0-正常 1-删除)
     * isNullAble:0,defaultVal:0
     */
    private Integer deleted;
    /**
     * 临时数据的原数据ids
     */
    private List<Long> parentIds;

    /**
     * 起始值
     */
    private Integer offset;
    /**
     * 查询数量
     */
    private Integer pageSize;

    /**
     * 需要排除的页面
     */
    private List<Long> excludePageIds;

    public List<Long> getExcludePageIds() {
        return excludePageIds;
    }

    public void setExcludePageIds(List<Long> excludePageIds) {
        this.excludePageIds = excludePageIds;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public String getSkinName() {
        return skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public Integer getSkinMode() {
        return skinMode;
    }

    public void setSkinMode(Integer skinMode) {
        this.skinMode = skinMode;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Boolean getIncludeIndex() {
        return includeIndex;
    }

    public void setIncludeIndex(Boolean includeIndex) {
        this.includeIndex = includeIndex;
    }

    public List<Long> getParentIds() {
        return parentIds;
    }

    public void setParentIds(List<Long> parentIds) {
        this.parentIds = parentIds;
    }

    public Integer getOffset() {
        return offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
