package cn.com.duiba.developer.center.api.remoteservice.crm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.crm.ClueAppDto;
import cn.com.duiba.developer.center.api.domain.param.crm.ClueSelectParam;

import java.util.List;

/**
 * @author 刘凯
 * @date 2020-06-12
 */
@AdvancedFeignClient
public interface RemoteClueAppService {


    Long save(ClueAppDto clueAppDto);

    Long deleteById(Long id);

    Long deleteBatchByIds(List<Long> ids);

    Long updateById(ClueAppDto clueAppDto);

    ClueAppDto getById(Long id);

    List<ClueAppDto> listByIds(List<Long> ids);

    List<Long> selectClueAppByParams(ClueSelectParam param);

    Integer selectCountClueAppByParams(ClueSelectParam param);

    List<ClueAppDto> listByCludId(Long clueId);

    List<ClueAppDto> getByClueIdAndDeveloperId(Long developerId,Long clueId);

    void changeClueAppApplyStage(List<Long> clueAppIds,Integer applyStage);

    void saveBatch(List<ClueAppDto> clueAppDto);

    ClueAppDto getClueAppByClueIdAndAppId(Long clueId, Long appId);

    ClueAppDto getByAppId(Long appId);

}
