package cn.com.duiba.developer.center.api.aspectj;

import cn.com.duiba.developer.center.api.utils.MD5;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtil;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtilBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 这里通过CommandLineRunner，在spring 刷新完毕之后，启动一个处理
 *
 * @Author 刘凯
 * @Date 2022/7/27 11:37 上午 （可以根据需要修改）
 * @Version 1.0 （版本号）
 */
@Component
public class CustomCodeReportRunner implements CommandLineRunner {


    private static final Logger logger = LoggerFactory.getLogger(CustomCodeReportRunner.class);


    @Resource
    private WhiteAccessUtilBase whiteAccessUtilBase;

    @Autowired
    private Environment environment;


    @Override
    public void run(String... args) throws Exception {
        logger.info("自动上报定制代码 开始");
        WhiteAccessUtilBase.sysName = environment.getProperty("spring.application.name");

        WhiteAccessUtil.whiteAccessUtilBase = whiteAccessUtilBase;

    }


    public static String getMd5Str(String value, String sysName, String className) {
        return MD5.md5(value + sysName + className);
    }
}
