package cn.com.duiba.developer.center.api.domain.dto.survey;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

public class UserRecordDto implements Serializable {
    private static final long serialVersionUID = -6967812124962282384L;
    /**
     * ID
     */
    private Long id;
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 问券Id
     */
    private Long surveyId;
    /**
     * 问券版本
     */
    private Integer version;

    /**
     * 场景值
     */
    @Size(max = 128, message = "场景值过长")
    private String channel = "default";

    /**
     * 开发者(消费)id
     */
    @NotNull
    @Min(value = 1, message = "consumerId不合法")
    private Long consumerId;
    /**
     *
     */
    private Long appId;

    /**
     * 是否结束答题
     */
    private Boolean finishSurvey;

    /**
     * 开始填写时间
     */
    @Past
    private Date startAt;
    /**
     * 结束填写时间
     */
    @Past
    private Date endAt;

    /**
     * 不同app定制存储的信息
     */
    private String customInfo;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getSurveyId() {
        return surveyId;
    }

    public void setSurveyId(Long surveyId) {
        this.surveyId = surveyId;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Date getStartAt() {
        return startAt;
    }

    public void setStartAt(Date startAt) {
        this.startAt = startAt;
    }

    public Date getEndAt() {
        return endAt;
    }

    public void setEndAt(Date endAt) {
        this.endAt = endAt;
    }

    public Boolean getFinishSurvey() {
        return finishSurvey;
    }

    public void setFinishSurvey(Boolean finishSurvey) {
        this.finishSurvey = finishSurvey;
    }

    public String getCustomInfo() {
        return customInfo;
    }

    public void setCustomInfo(String customInfo) {
        this.customInfo = customInfo;
    }
}
