package cn.com.duiba.developer.center.api.domain.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 业务功能导出平台类型枚举
 * author zhanghuifeng
 * date 2018-11-27-16:38
 */
public enum BusinessExportPlatformTypeEnum {
    DEVELOPER(1, "开发者后台"),
    DUIBA(2, "兑吧后台"),
    SUPPLIER(3, "分销后台");

    private Integer code;

    private String desc;

    BusinessExportPlatformTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BusinessExportPlatformTypeEnum> enumMap = new HashMap<>();
    static{
        for(BusinessExportPlatformTypeEnum platformTypeEnum : values()){
            enumMap.put(platformTypeEnum.getCode(), platformTypeEnum);
        }
    }

    public static BusinessExportPlatformTypeEnum getByCode(Integer code){
        BusinessExportPlatformTypeEnum platformTypeEnum = enumMap.get(code);
        if(platformTypeEnum == null){
            return null;
        }
        return platformTypeEnum;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }}
