package cn.com.duiba.developer.center.api.domain.paramquery.domain;

import java.io.Serializable;
import javax.validation.constraints.NotNull;

/**
 * 创建app关联标签
 */
public class CreateAppNewDomainQueryParams implements Serializable {
    private static final long serialVersionUID = -8640164431618251553L;

    /**
     * 域名前缀
     */
    private String prefix;

    @NotNull(message = "创建App必须指定开发者")
    private Long appId;

    @NotNull(message = "创建App必须选择标签")
    private Long labelId;

    public String getPrefix() {
        return prefix;
    }

    public CreateAppNewDomainQueryParams setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public Long getAppId() {
        return appId;
    }

    public CreateAppNewDomainQueryParams setAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    public Long getLabelId() {
        return labelId;
    }

    public CreateAppNewDomainQueryParams setLabelId(Long labelId) {
        this.labelId = labelId;
        return this;
    }
}
