package cn.com.duiba.developer.center.api.remoteservice.visualeditor;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.visualeditor.HbaseMigrationResultDto;

/**
 * HBase数据迁移远程服务接口
 * 
 * @author system
 * @date 2025/01/XX
 */
@AdvancedFeignClient
public interface RemoteVisualEditorHbaseMigrationService {

    /**
     * 根据应用ID将HBase中的组件dataJson迁移到MySQL
     * 
     * @param appId 应用ID
     * @return 迁移结果信息
     */
    HbaseMigrationResultDto migrateByAppId(Long appId);

    /**
     * 全量迁移组件模板表的config_data_json从HBase到MySQL
     * 
     * @return 迁移结果信息
     */
    HbaseMigrationResultDto migrateSkinUnitConfigDataJson();
}
