package cn.com.duiba.developer.center.api.domain.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * 加钱购审核对象
 */
public class AmbDeveloperWithdrawCashAuditDto implements Serializable{
	private static final long serialVersionUID = -6421879123307762926L;

	public static final String CashTypeBank      = "bank";      //NOSONAR 银行
	public static final String CashTypeAliPay    = "alipay";    //NOSONAR 支付宝
	public static final String CashTypeRemaining = "remaining"; //NOSONAR 余额

	public static final String TypePersonal      = "personal";  //NOSONAR 个人
	public static final String TypeCompany       = "company";   //NOSONAR 企业

	public static final String StatusCreate        = "create";     //NOSONAR 待审核
	public static final String StatusWait          = "wait";     //NOSONAR 待审核
	public static final String StatusPass          = "pass";     //NOSONAR 审核通过
	public static final String StatusReject        = "reject";   //NOSONAR 审核拒绝


	private Long id;

	private Long developerId;

	private String cashType; //提现类型

	private String businessLicencePic;//营业执照

	private String idCardFrontPic;//身份证正面

	private String idCardBackPic;//身份证反面

	private String bank;//银行

	private String bankProvince;//银行所在省

	private String bankCity;//银行所在市

	private String bankBranchName;//分行名称

	private String bankAccountNumber;//银行帐户

	private String bankAccountName;//银行帐户开户名称

	private String alipayAccountNumber;//支付宝帐户

	private String alipayAccountName;//支付宝帐户名称

	private String status;

	private String description;

	private String memo;

	private String registerEmail;//注册邮箱

	private String phone;//手机号

	private Boolean isValid;

	private Date gmtCreate;

	private Date gmtModified;

	private String email;

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * 开发者应用ID
	 */
	private Long appId;

	/**
	 * 插入构造方法
	 * @param init4insert 插入标记
	 */
	public AmbDeveloperWithdrawCashAuditDto(boolean init4insert) {
		if (init4insert) {
			isValid = false;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	/**
	 * 更新构造方法
	 * @param id 更新实体Id
	 */
	public AmbDeveloperWithdrawCashAuditDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 * 无参数构造函数
	 */
	public AmbDeveloperWithdrawCashAuditDto() {
		super();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getDeveloperId() {
		return developerId;
	}

	public void setDeveloperId(Long developerId) {
		this.developerId = developerId;
	}

	public String getCashType() {
		return cashType;
	}

	public void setCashType(String cashType) {
		this.cashType = cashType;
	}

	public String getBusinessLicencePic() {
		return businessLicencePic;
	}

	public void setBusinessLicencePic(String businessLicencePic) {
		this.businessLicencePic = businessLicencePic;
	}

	public String getIdCardFrontPic() {
		return idCardFrontPic;
	}

	public void setIdCardFrontPic(String idCardFrontPic) {
		this.idCardFrontPic = idCardFrontPic;
	}

	public String getIdCardBackPic() {
		return idCardBackPic;
	}

	public void setIdCardBackPic(String idCardBackPic) {
		this.idCardBackPic = idCardBackPic;
	}

	public String getBank() {
		return bank;
	}

	public void setBank(String bank) {
		this.bank = bank;
	}

	public String getBankProvince() {
		return bankProvince;
	}

	public void setBankProvince(String bankProvince) {
		this.bankProvince = bankProvince;
	}

	public String getBankCity() {
		return bankCity;
	}

	public void setBankCity(String bankCity) {
		this.bankCity = bankCity;
	}

	public String getBankBranchName() {
		return bankBranchName;
	}

	public void setBankBranchName(String bankBranchName) {
		this.bankBranchName = bankBranchName;
	}

	public String getBankAccountNumber() {
		return bankAccountNumber;
	}

	public void setBankAccountNumber(String bankAccountNumber) {
		this.bankAccountNumber = bankAccountNumber;
	}

	public String getBankAccountName() {
		return bankAccountName;
	}

	public void setBankAccountName(String bankAccountName) {
		this.bankAccountName = bankAccountName;
	}

	public String getAlipayAccountNumber() {
		return alipayAccountNumber;
	}

	public void setAlipayAccountNumber(String alipayAccountNumber) {
		this.alipayAccountNumber = alipayAccountNumber;
	}

	public String getAlipayAccountName() {
		return alipayAccountName;
	}

	public void setAlipayAccountName(String alipayAccountName) {
		this.alipayAccountName = alipayAccountName;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public String getRegisterEmail() {
		return registerEmail;
	}

	public void setRegisterEmail(String registerEmail) {
		this.registerEmail = registerEmail;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public Boolean getIsValid() {
		return isValid;
	}

	public void setIsValid(Boolean isValid) {
		this.isValid = isValid;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Boolean getValid() {
		return isValid;
	}

	public void setValid(Boolean valid) {
		isValid = valid;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}
}