package cn.com.duiba.developer.center.api.domain.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 业务功能导出结果枚举
 * author zhanghuifeng
 * date 2018-11-27-19:12
 */
public enum BusinessExportStateEnum {

    DEALING(1, "处理中"),
    SUCCESS(2, "成功"),
    FAILED(3, "失败");

    private Integer code;

    private String desc;

    BusinessExportStateEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, BusinessExportStateEnum> enumMap = new HashMap<>();
    static{
        for(BusinessExportStateEnum exportStateEnum : values()){
            enumMap.put(exportStateEnum.getCode(), exportStateEnum);
        }
    }

    public static BusinessExportStateEnum getByCode(Integer code){
        BusinessExportStateEnum exportStateEnum = enumMap.get(code);
        if(exportStateEnum == null){
            return null;
        }
        return exportStateEnum;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
