package cn.com.duiba.developer.center.api.domain.dto;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by liuyao on 2016/9/28.
 */
public class DeveloperDto implements Serializable {

    public static final int SWITCH_BANNER = 1;
    public static final int SWITCH_POWERED_BY = 2;// 位运算第二位，表示是否在该开发者手机端展示powered by
    public static final int SWITCH_CLOSEWITHDRAWTOPERSONAL = 3; //是否关闭提现到个人帐户

    public static final String IP = "ip";

    private Long id;
    private String email;
    private String password;
    private String name;
    private String company;
    private String phone;
    private Boolean verify;
    private Boolean enable;
    private Integer remindMoney;
    private Date lastRemindTime;
    private Integer developerSwitch;
    private String json;
    private Date gmtCreate;
    private Date gmtModified;
    //业务主体
    private String subject;
    //更新业务主体的时间
    private Date modifiedSubjectTime;
    //渠道
    private String channel;

    private AppSimpleDto fristApp;//第一个创建的App

    private Integer createSource;//该条数据来源，0：兑吧 or 1：推啊

    /**
     * true=白名单 false(默认)=不是白名单
     */
    private Boolean bDevFree=false;

    /**
     * 判断开关的状态
     *
     * @param type 开关位
     * @return
     */
    public boolean getSwitch(Integer type) {
        int v = 1 << type.intValue();
        int ret = this.developerSwitch.intValue() & v;
        return ret != 0;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Boolean getVerify() {
        return verify;
    }

    public void setVerify(Boolean verify) {
        this.verify = verify;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Integer getRemindMoney() {
        return remindMoney;
    }

    public void setRemindMoney(Integer remindMoney) {
        this.remindMoney = remindMoney;
    }

    public Date getLastRemindTime() {
        return lastRemindTime;
    }

    public void setLastRemindTime(Date lastRemindTime) {
        this.lastRemindTime = lastRemindTime;
    }

    public Integer getDeveloperSwitch() {
        return developerSwitch;
    }

    public void setDeveloperSwitch(Integer developerSwitch) {
        this.developerSwitch = developerSwitch;
    }

    public String getJson() {
        return json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public AppSimpleDto getFristApp() {
        return fristApp;
    }

    public void setFristApp(AppSimpleDto fristApp) {
        this.fristApp = fristApp;
    }

    public Boolean getbDevFree() {
        return bDevFree;
    }

    public void setbDevFree(Boolean bDevFree) {
        this.bDevFree = bDevFree;
    }

    public Integer getCreateSource() {
        return createSource;
    }

    public void setCreateSource(Integer createSource) {
        this.createSource = createSource;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Date getModifiedSubjectTime() {
        return modifiedSubjectTime;
    }

    public void setModifiedSubjectTime(Date modifiedSubjectTime) {
        this.modifiedSubjectTime = modifiedSubjectTime;
    }
}
