package cn.com.duiba.developer.center.api.domain.dto.visualeditor;

import cn.com.duiba.developer.center.api.domain.enums.visualeditor.CommTemplateUnitTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.visualeditor.OpenStatusEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 通用组件表
 */
public class VisualEditorCommTemplateUnitDto implements Serializable {

    private static final long serialVersionUID = -4544227911691023530L;
    /**
     * 物理主键
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 名称
     */
    private String unitName;

    /**
     * 组件类型 0-底部操作栏
     */
    private CommTemplateUnitTypeEnum unitType;

    /**
     * 组件数据
     */
    private String dataJson;

    /**
     * 上下架标识( 0-隐藏 1-开启)
     */
    private OpenStatusEnum openStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 删除标志位(0-正常 1-删除)
     */
    private Integer deleted;


    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public String getDataJson() {
        return dataJson;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public CommTemplateUnitTypeEnum getUnitType() {
        return unitType;
    }

    public void setUnitType(CommTemplateUnitTypeEnum unitType) {
        this.unitType = unitType;
    }

    public OpenStatusEnum getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(OpenStatusEnum openStatus) {
        this.openStatus = openStatus;
    }
}