/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import java.net.URI;
import java.net.URLDecoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtils {
    private static final Logger logger = LoggerFactory.getLogger(UrlUtils.class);

    public static String getRedirectHost(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            URI uri = new URI(url);
            if (StringUtils.isBlank((CharSequence)uri.getHost())) {
                String urlStr = URLDecoder.decode(url, "UTF-8");
                uri = new URI(urlStr);
            }
            return uri.getHost();
        }
        catch (Exception e) {
            logger.error("URLDecoder.decode error:{}", (Object)url, (Object)e);
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String url = "http://www.baidu.com/xxx/yyy?zzz=1";
        String host = UrlUtils.getRedirectHost(url);
        int index = url.indexOf(host);
        int start = index + host.length();
        String subString = url.substring(start, url.length());
        System.out.println(host + "***" + index);
        System.out.println(subString);
    }
}

