package cn.com.duiba.developer.center.api.remoteservice.strategy;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.PageDto;
import cn.com.duiba.developer.center.api.domain.dto.strategy.StrategyCaseDto;
import cn.com.duiba.developer.center.api.domain.paramquery.StrategyCaseQuery;

import java.util.List;

/**
 * 案例-远程服务接口
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
@AdvancedFeignClient
public interface RemoteStrategyCaseService {
    /**
     * 根据案例ID查询
     *
     * @param id
     * @return
     */
    StrategyCaseDto findById(Long id);

    /**
     * 根据id列表查询
     *
     * @param ids
     * @return
     */
    List<StrategyCaseDto> findByIds(List<Long> ids);

    /**
     * 根据复合条件分页查询
     *
     * @param query    查询条件
     * @param pageNo   当前页
     * @param pageSize 查询数量
     * @return 分页数据
     */
    PageDto<StrategyCaseDto> pageByQuery(StrategyCaseQuery query, int pageNo, int pageSize);

    /**
     * 插入新纪录
     *
     * @param record
     * @return
     */
    Long insert(StrategyCaseDto record);

    /**
     * 更新记录
     *
     * @param record
     */
    void update(StrategyCaseDto record);

    /**
     * 更新案例状态
     *
     * @param id
     * @param status
     */
    void updateStatusById(Long id, Integer status);

    /**
     * 新增客户满意度
     *
     * @param id
     * @param satisfaction
     */
    void insertSatisfaction(Long id, StrategyCaseDto.Satisfaction satisfaction);

    /**
     * 更新有效性
     *
     * @param id
     * @param validation
     * @param validationText
     */
    void updateValidationById(Long id, Integer validation, String validationText);

    /**
     * 更新客户预期数据
     *
     * @param id
     * @param expectData
     */
    void updateExpectDataById(Long id, String expectData);

    /**
     * 更新最后修改者
     *
     * @param id
     * @param modifiedUser
     */
    void updateModifiedUserById(Long id, String modifiedUser);

    /**
     * 删除案例
     *
     * @param id
     */
    void deleteById(Long id);

    /**
     * 活动ID是否已存在
     *
     * @param activityId
     * @return
     */
    boolean existsActivity(String activityId);
}