package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Objects;

public enum AppRoundIngTypeEnum {
    UP(1,"向上取整"),
    DOWN(2,"向下取整"),
    ROUNDING(3,"四舍五入"),;

    private Integer code;

    private String desc;

    AppRoundIngTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static AppRoundIngTypeEnum getEnumByStatus(Integer code){
        if(null == code){
            return null;
        }
        for (AppRoundIngTypeEnum enumVal : AppRoundIngTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }
}
