package cn.com.duiba.developer.center.api.domain.enums;

/**
 * Created by qianjue on 2017/11/24.
 */
public enum StatusEnum {

    STATUS_OPEN(1, "开启"),
    STATUS_CLOSED(0, "关闭");

    private Integer code;
    private String desc;


    public static StatusEnum getStatusByCode(Integer code) {
        for (StatusEnum en : StatusEnum.values()) {
            if (en.getCode().equals(code)) {
                return en;
            }
        }
        return null;
    }


    StatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

    public static boolean isOpen(Integer sta) {
        return STATUS_OPEN.getCode().equals(sta);
    }

    public static boolean isClose(Integer sta) {
        return STATUS_CLOSED.getCode().equals(sta);
    }
}
